/**
* \file: Singleton.h
*
* \version: 1.0
*
* \release: $Name:$
*
* Implementation of Singleton pattern
*
* \component: Unified SPI
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_SINGLETON_H
#define USPI_SINGLETON_H

namespace adit { namespace uspi {

template<class Type> class Singleton
{
private:
    Singleton(const Singleton& inObj) { }
    Singleton& operator = (const Singleton& inObj) { return *this; }

public:
    static Type& instance()
    {
#if !defined(__GNUC__) || (__GNUC__ <= 3)
#error // not supported, TODO add proper locking
#endif
        static Type _instance; // this is guaranteed to be thread-safe
        return _instance;
    }

protected:
    Singleton() {};
    virtual ~Singleton() {};
};

} } /* namespace adit { namespace uspi { */

#endif /* USPI_SINGLETON_H */
